<?php declare(strict_types = 1);


namespace EshopOrders\Model\Entities;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table("eshop_orders__group_customers")
 * @ORM\Entity
 */
class GroupCustomers
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var string
	 * @ORM\Column(name="name", type="string", length=60)
	 */
	public $name;

	/**
	 * @var int
	 * @ORM\Column(name="is_published", type="smallint", length=1)
	 */
	public $isPublished;

	/**
	 * @var Customer[]
	 * @ORM\OneToMany(targetEntity="Customer", mappedBy="groupCustomers", indexBy="id", cascade={"all"})
	 */
	protected $customers;

	/**
	 * GroupCustomers constructor.
	 */
	public function __construct()
	{
		$this->customers = new ArrayCollection();
	}
}
