<?php declare(strict_types=1);

namespace EshopOrders\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/** podobne jako order_item, ale samostatna tabulka
 * @ORM\Table("eshop_orders__order_payment")
 * @ORM\Entity
 */
class OrderPayment
{
	use Identifier;
	use MagicAccessors;
	
	/**
	 * @var Payment
	 * @ORM\ManyToOne(targetEntity="Payment")
	 * @ORM\JoinColumn(name="payment_id", referencedColumnName="id", onDelete="SET NULL")
	 */
	public $payment;
	
	/**
	 * @var string
	 * @ORM\Column(name="name", type="string")
	 */
	protected $name;
	
	/**
	 * @var int
	 * @ORM\Column(name="price", type="smallint")
	 */
	protected $price;
	
	/**
	 * @var Order
	 * @ORM\OneToOne(targetEntity="Order", inversedBy="payment")
	 * @ORM\JoinColumn(name="order_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public $order;
	
	public function __construct(Payment $payment, Order $order)
	{
		$this->payment = $payment;
		$this->name    = $payment->getName();
		$this->price   = $payment->getPrice();
		$this->order   = $order;
	}
	
	/**
	 * @return Payment|null
	 */
	public function getPayment()
	{
		return $this->payment;
	}
	
	/**
	 * @return string
	 */
	public function getName(): string
	{
		return $this->name;
	}
	
	/**
	 * @param string $name
	 * @return OrderPayment
	 */
	public function setName(string $name): OrderPayment
	{
		$this->name = $name;
		return $this;
	}
	
	/**
	 * @return int
	 */
	public function getPrice(): int
	{
		return $this->price;
	}
	
	/**
	 * @param int $price
	 * @return OrderPayment
	 */
	public function setPrice(int $price): OrderPayment
	{
		$this->price = $price;
		return $this;
	}
	
	/**
	 * @return Order
	 */
	public function getOrder(): Order
	{
		return $this->order;
	}
	
}
