<?php declare(strict_types=1);

namespace EshopOrders\AdminModule\Components\Expedition;

use Core\Model\Event\CreateFormEvent;
use Core\Model\Event\FormSuccessEvent;
use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use Nette\Forms\Form;
use Nette\Utils\ArrayHash;
use Nette\Utils\Json;
use Nette\Utils\Validators;

class ExpeditionAdvancedOptionsForm extends BaseControl
{
	protected ?string $speditionIdent = null;

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	public function createComponentForm(): BaseForm
	{
		$form = $this->createForm();
		$form->setShowLangSwitcher(false)
			 ->setAjax();
		$form->addHidden('orderIds')
			 ->setRequired();
		$form->addHidden('speditionIdent')
			 ->setRequired();
		$form->addText('quantity', 'eshopOrders.expeditionOrdersGrid.form.quantity')
			 ->setHtmlType('number')
			 ->setPlaceholder($this->t('eshopOrders.expeditionOrdersGrid.form.quantity'))
			 ->addCondition($form::FILLED)
			 	->addRule($form::INTEGER);
		$form->addSaveCancelControl()
			 ->closeModalOnCancel();

		$event = new CreateFormEvent($form, $this->getPresenter(false) ? $this->template : null);
		$event->control = $this;

		$this->eventDispatcher->dispatch($event, ExpeditionAdvancedOptionsForm::class . '::createForm-' . $this->speditionIdent);

		$form->onSuccess[]  = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(Form $form, ArrayHash $values): void
	{
		if (empty($values->quantity) || !Validators::isNumericInt($values->quantity)) {
			$values->quantity = 1;
		}
		$values->orderIds = Json::decode($values->orderIds, Json::FORCE_ARRAY);
		$event = new FormSuccessEvent($form, $values,
			$this->getPresenter(false) ? $this->template : null, $this->getPresenter(false) ? $this->getPresenter() : null);
		$this->eventDispatcher->dispatch($event, self::class . '::formSuccess-' . $values->speditionIdent);
	}

	public function setDefaults(array $orderIds, string $speditionIdent): void
	{
		$this->speditionIdent = $speditionIdent;
		$form = $this['form'];
		$form['orderIds']->setValue(Json::encode($orderIds));
		$form['speditionIdent']->setValue($speditionIdent);
	}

}