<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Model;

use Core\Model\Entities\EntityManagerDecorator;
use EshopCatalog\FrontModule\Model\CacheService;
use EshopOrders\Model\Entities\Cart;
use Nette\Utils\DateTime;
use Tracy\Debugger;

class Carts
{
	protected EntityManagerDecorator $em;

	protected CacheService $cacheService;

	public function __construct(EntityManagerDecorator $em, CacheService $cacheService)
	{
		$this->em           = $em;
		$this->cacheService = $cacheService;
	}

	public function removeInactive(): void
	{
		Debugger::log('Carts - removeInactive', 'scheduler/' . (new DateTime())->format('y-m-d'));
		$this->em->createQueryBuilder()->delete(Cart::class, 'c')
			->where('c.lastActivity <= :date')
			->setParameter('date', (new DateTime())->modify('-14 days')->setTime(0,0,0))
			->getQuery()->execute();
	}
}
