<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use EshopOrders\Model\Entities\OrderStatus;
use Tracy\Debugger;

/**
 * class OrderStatuses
 * @package EshopOrders\Model
 *
 * @method OrderStatus|object|null getReference($id)
 * @method OrderStatus[]|null getAll()
 * @method OrderStatus|null get($id)
 */
class OrderStatuses extends BaseEntityService
{
	protected $entityClass = OrderStatus::class;

	public function removeProcessingStatus(int $orderId): bool
	{
		try {
			$id = $this->getEr()->createQueryBuilder('os')->select('os.id')
				->andWhere('os.order = :order')
				->andWhere('os.deleted IS NULL OR os.deleted = 0')
				->andWhere('os.status = :status')
				->orderBy('os.created', 'DESC')
				->setParameters([
					'order'  => $orderId,
					'status' => OrderStatus::STATUS_PROCESSING,
				])->setMaxResults(1)
				->getQuery()->getOneOrNullResult();

			if ($id) {
				$this->em->remove($this->getReference((int) $id['id']));
				$this->em->flush();

				return true;
			}
		} catch (\Exception $e) {
			Debugger::log('Remove processing status - ' . $e->getMessage());
		}

		return false;
	}
}
