<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use EshopOrders\Model\Entities\OrderStatus;
use EshopOrders\Model\Entities\Spedition;
use EshopOrders\Model\EshopOrdersConfig;

/**
 * @method Spedition|object|null getReference($id)
 * @method Spedition[]|null getAll()
 * @method Spedition|null get($id)
 */
class Speditions extends BaseEntityService
{
	protected $entityClass = Spedition::class;

	protected ?array $cForSelectOption = null;

	protected ?array $cByIdent = null;

	public function getByIdent(string $ident): ?Spedition
	{
		if ($this->cByIdent === null) {
			$this->cByIdent = [];

			foreach ($this->getEr()->findAll() as $row)
				$this->cByIdent[$row->getIdent()] = $row;
		}

		return $this->cByIdent[$ident] ?? null;
	}

	public function setPosition($id, $position)
	{
		if ($item = $this->get($id)) {
			$item->setPosition($position);
			$this->em->persist($item);
			$this->em->flush();

			return true;
		}

		return false;
	}

	public function setPublish($id, $state)
	{
		if ($item = $this->getReference($id)) {
			$item->isPublished = $state;
			$this->em->persist($item);
			$this->em->flush();

			return true;
		}

		return false;
	}

	public function getForSelectOption(): array
	{
		if ($this->cForSelectOption === null)
			$this->cForSelectOption = $this->getEr()->findPairs([], 'name') ?: [];

		return $this->cForSelectOption;
	}

	/**
	 * Vrátí ID objednávek které lze exportovat. Je nutná následná filtrace.
	 */
	public function checkOrdersGridMenuExportOnlyInStatus(array $ids): array
	{
		$onlyInStatus = EshopOrdersConfig::load('ordersGridMenuExportOnlyInStatus', null);

		if ($onlyInStatus === null)
			return $ids;

		$allowed = [];
		foreach ($this->em->getRepository(OrderStatus::class)->createQueryBuilder('os')
			         ->select('IDENTITY(os.order) as order')
			         ->where('os.order IN (:order)')->setParameter('order', $ids)
			         ->andWhere('os.status = :status')->setParameter('status', $onlyInStatus)
			         ->andWhere('os.deleted IS NULL')
			         ->groupBy('os.order')->getQuery()->getArrayResult() as $row)
			$allowed[] = $row['order'];

		return $allowed;
	}
}
