<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Presenters;

use EshopOrders\AdminModule\Components\Invoice\IInvoicesGridFactory;
use EshopOrders\AdminModule\Components\Invoice\InvoicesGrid;
use EshopOrders\AdminModule\Model\Event\InvoiceRegenerateEvent;
use Nette\Application\UI\InvalidLinkException;

class InvoicePresenter extends BasePresenter
{
	protected function startup(): void
	{
		parent::startup();
		$this->eventDispatcher->addListener('eshopOrders.afterSaveRegeneratedInvoice', function(InvoiceRegenerateEvent $event) {
			$this['invoicesGrid']['grid']->reload();
		});
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	/**
	 * @throws InvalidLinkException
	 */
	public function actionDefault(): void
	{
		$this->setHeader('eshopOrders.title.invoices', 'fa fa-shopping-cart');

		// invoice settings navigation item
		$navigation[] = [
			'title' => 'eshopOrders.menu.invoiceSettings',
			'link'  => $this->link('InvoiceConfigs:default'),
			'ico'   => 'fas fa-cogs',
		];

		$this['navigation']->setData(['header' => $navigation]);
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	/**
	 * @param IInvoicesGridFactory $factory
	 *
	 * @return InvoicesGrid
	 */
	public function createComponentInvoicesGrid(IInvoicesGridFactory $factory): InvoicesGrid
	{
		return $factory->create();
	}

}
