<?php declare(strict_types = 1);

namespace EshopOrders\Console\Cart;

use Doctrine;
use Doctrine\ORM\Tools\Console\Command\SchemaTool\AbstractCommand;
use EshopOrders\AdminModule\Model\Carts;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;

class Clean extends AbstractCommand
{
	/** @var Carts|null @inject */
	public ?Carts $carts = null;

	protected function configure()
	{
		$this->setName('eshoporders:cart:clean')->setDescription('Clean inactive carts');
	}

	protected function executeSchemaCommand(InputInterface $input, OutputInterface $output, Doctrine\ORM\Tools\SchemaTool $schemaTool, array $metadatas, SymfonyStyle $ui)
	{
		$output->writeln('CLEAR INACTIVE CARTS');

		try {
			$this->carts->removeInactive();

			$output->writeLn('<info>[OK] - carts cleaned</info>');
		} catch (\Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 0;
	}
}
