<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Components\Cart;

use Core\Model\UI\BaseControl;
use EshopCatalog\DI\EshopCatalogExtension;
use EshopCatalog\Model\Config as EshopCatalogConfig;
use EshopOrders\FrontModule\Model\Dao\Cart;
use EshopOrders\FrontModule\Model\Carts;
use EshopOrders\Model\EshopOrdersConfig;
use Nette\Utils\Html;

class CartPreview extends BaseControl
{
	/** @var Carts */
	private $cartsService;

	/** @var Cart */
	private $cart;

	public function __construct(Carts $carts)
	{
		$this->cartsService = $carts;
	}

	public function render(): void
	{
		if (class_exists(EshopCatalogExtension::class)
			&& EshopCatalogConfig::load('allowAddToCartOnlyForLoggedUsers') && !$this->getPresenter()->getUser()->isLoggedIn())
			return;

		$this->template->setFile($this->getTemplateFile());
		$this->template->itemsCountRaw = $this->getCart()->getItemsCount();
		$this->template->itemsCount    = $this->getItemsCountFormatted();
		$this->template->itemsPrice    = $this->getPriceFormatted();
		$this->template->render();
	}

	public function renderMobile(): void
	{
		$this->template->isMobile = true;
		$this->render();
	}

	public function getItemsCountRaw(): int { return (int) $this->getCart()->getItemsCount() ?: 0; }

	public function getPriceFormatted(): Html
	{
		$price = EshopOrdersConfig::load('cartPreview.showPriceWithoutVat')
			? $this->getCart()->getCartItemsPrice(false)
			: $this->getCart()->getCartItemsPrice();

		return Html::el()->setHtml($this->template->getLatte()->invokeFilter('price', [$price]));
	}

	public function getItemsCountFormatted(): Html
	{
		$itemsCount = $this->getCart()->getItemsCount();

		if (EshopOrdersConfig::load('cartPreview.style') === 2)
			return Html::el()->setText($itemsCount);

		if ($itemsCount > 0)
			return Html::el()->setHtml($this->getCart()->getItemsCount() .
				' <span class="cart-preview__items-text">' . $this->t('eshopCatalogFront.cartAddForm.items') . '</span>');

		return Html::el()->setHtml('<span>0 ' . $this->t('eshopCatalogFront.cartAddForm.items') . '</span>');
	}

	public function getCart(): Cart
	{
		if (!$this->cart) {
			$this->cart = $this->cartsService->getCurrentCart();
		}

		return $this->cart;
	}

	/*******************************************************************************************************************
	 * ============================== Signals
	 */

}

