<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model\Dao;

use Core\Model\Application\AppState;
use EshopOrders\Model\Entities\IDiscount;
use EshopOrders\Model\Entities\OrderDiscount;

class Discount implements IDiscount
{

	/** @var string */
	public $id;

	/** @var string */
	public $title;

	/** @var float */
	public $amount;

	/** @var float */
	public $amountInBaseCurrency;

	/** @var float */
	public $discount;

	/** @var string */
	public $type;

	/** @var string */
	public $typeSymbol = '';

	/** @var string */
	public $packageType;

	public ?string $text = null;

	public $calculateDiscountCallback = null;

	public function __construct(string $id, float $amount, string $type, string $packageType)
	{
		$this->id          = $id;
		$this->amount      = $amount;
		$this->type        = $type;
		$this->packageType = $packageType;
	}

	public function calculateDiscount(float $price, bool $useBaseCurrency = false): float
	{
		if (is_callable($this->calculateDiscountCallback)) {
			return call_user_func($this->calculateDiscountCallback, $this);
		} else {
			$amount = $useBaseCurrency ? $this->amountInBaseCurrency : $this->amount;
			if ($this->type == OrderDiscount::TYPE_PERCENT)
				$discount = -($price * ((float) $amount / 100));
			else
				$discount = -((float) $amount);

			if (!$useBaseCurrency)
				$this->discount = $discount;

			return round($discount, (int) AppState::getState('eshopOrdersCartDecimals', 0));
		}
	}

	/**
	 * @return float
	 */
	public function getValue(): float
	{
		return $this->amount;
	}

	/**
	 * @return string
	 */
	public function getType(): string
	{
		return $this->type;
	}
}



