<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model\Event;

use Symfony\Contracts\EventDispatcher\Event;

class UpdatedCartItemEvent extends Event
{
	/** @var int */
	public $itemId;

	/** @var int */
	public $quantity;

	public int $beforeQuantity;

	public array $moreData;

	public function __construct(int $itemId, int $quantity, int $beforeQuantity, array $moreData = [])
	{
		$this->itemId         = $itemId;
		$this->quantity       = $quantity;
		$this->beforeQuantity = $beforeQuantity;
		$this->moreData       = $moreData;
	}
}
