<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Presenters;

use Core\Model\Event\PresenterTemplateEvent;
use Doctrine\ORM\Query;
use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\Orders;
use EshopOrders\Model\Payments;
use EshopOrders\Model\Statuses;

class PaymentPresenter extends BasePresenter
{
	/** @persistent */
	public $orderIdent;

	protected Payments $paymentsService;

	/** @var Orders */
	protected $ordersService;

	/** @var Statuses */
	protected $statusesService;

	public ?Order $order = null;

	protected array $includeTemplates = [];

	public function __construct(Orders $orders, Statuses $statuses, Payments $payments)
	{
		$this->ordersService   = $orders;
		$this->statusesService = $statuses;
		$this->paymentsService = $payments;
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionPay($orderIdent)
	{
		if ($this->getParameter('orderIdent')) {
			$this->order = $this->ordersService->getByIdent($orderIdent);
		}

		if (!$this->order)
			$this->error();

		$cannotPayWithCard = false;

		if ($this->order->getPaymentIdent() !== 'card')
			$cannotPayWithCard = true;

		if ($cannotPayWithCard) {
			$this->template->bigTitle = 'eshopOrdersFront.errors.error';
			$this->template->messages = [
				'eshopOrdersFront.errors.orderCantBePaidWithCard',
			];
		} else {
			$this->eventDispatcher->dispatch(new PresenterTemplateEvent($this->template, $this), 'eshopOrders.paymentPayAction');
			$this->terminate();
		}
	}

	public function actionPaymentFinished()
	{
		$orderIdent = $this->getParameter('orderIdent');

		if ($orderIdent) {
			// Podle ident
			$this->order = $this->ordersService->getByIdent($orderIdent);
		} else {
			// Podle id
			$orderId = $this->getParameter('orderId');

			if ($orderId)
				$this->order = $this->ordersService->getEr()->find((int) $orderId);
			else {
				// Comgate
				$orderIdent = $this->getHttpRequest()->getPost('refId');

				if ($orderIdent)
					$this->order = $this->ordersService->getEr()->find((int) $orderIdent);
			}
		}

		if ($this->order)
			$this->template->order = $this->order;

		$this->eventDispatcher->dispatch(new PresenterTemplateEvent($this->template, $this), 'eshopOrders.paymentFinishedRender');
		$this->template->includeTemplates = $this->includeTemplates;
	}

	/*******************************************************************************************************************
	 * ============================== Renders
	 */

	public function renderPaymentFinished()
	{
		//flash zpravy zobrazime v textu, ne jako prekryvne
		$this->template->messages     = $this->getTemplate()->flashes;
		$this->getTemplate()->flashes = [];
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	public function addIncludeTemplate(string $file): self
	{
		$this->includeTemplates[] = $file;

		return $this;
	}
}
