<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Core\Model\Entities\Site;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\Model\Entities\Seller;
use Gedmo\Mapping\Annotation as Gedmo;
use EshopOrders\Model\Entities\Invoice\InvoiceData;
use Core\Model\Entities\TId;
use Nette\Utils\DateTime;

/**
 * @ORM\Table("eshop_orders__invoice")
 * @ORM\Entity
 * @ORM\EntityListeners({"EshopOrders\Model\Listeners\InvoiceListener"})
 */
class Invoice
{
	use TId;

	/**
	 * @var DateTime
	 * @ORM\Column(type="datetime", nullable = false)
	 */
	public $dueDate;

	/**
	 * @var string
	 * @ORM\Column(type="string", nullable = false)
	 */
	public $ident;

	/**
	 * @var Order
	 * @ORM\OneToOne(targetEntity="Order", mappedBy="invoice", cascade={"persist"})
	 */
	public $order;

	/**
	 * @var DateTime
	 * @Gedmo\Timestampable(on="create")
	 * @ORM\Column(type="datetime", nullable=false)
	 */
	public $createdAt;

	/**
	 * @var InvoiceData
	 * @ORM\OneToOne(targetEntity="EshopOrders\Model\Entities\Invoice\InvoiceData", mappedBy="invoice", cascade={"persist"})
	 */
	public $invoiceData;

	/**
	 * @var Seller
	 * @ORM\ManyToOne(targetEntity="EshopCatalog\Model\Entities\Seller")
	 * @ORM\JoinColumn(name="seller_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public $seller;

	/**
	 * @ORM\Column(type="text", nullable = true)
	 */
	public ?string $note = null;

	/**
	 * Invoice constructor.
	 *
	 * @param DateTime $dueDate
	 * @param string   $ident
	 * @param Seller   $seller
	 */
	public function __construct(DateTime $dueDate, string $ident, Seller $seller)
	{
		$this->dueDate = $dueDate;
		$this->ident   = $ident;
		$this->seller  = $seller;
	}
}
