<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Core\Model\Entities\TId;

/**
 * @ORM\Table("eshop_orders__invoice_config")
 * @ORM\Entity
 */
class InvoiceConfig
{
	use TId;

	public const TYPE_INVOICE = 'invoice';
	public const TYPE_CORRECTIVE = 'corrective';

	/**
	 * @var int
	 * @ORM\Column(type="integer", nullable=false)
	 */
	public int $maturity;

	/**
	 * @var NumericalSeries
	 * @ORM\OneToOne(targetEntity="NumericalSeries", cascade={"all"})
	 * @ORM\JoinColumn(name="numerical_series_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public NumericalSeries $numericalSeries;

	/**
	 * @var NumericalSeries
	 * @ORM\OneToOne(targetEntity="NumericalSeries", cascade={"all"})
	 * @ORM\JoinColumn(name="corrective_tax_numerical_series_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public NumericalSeries $correctiveNumericalSeries;

	/**
	 * @var ArrayCollection|SellerInvoiceConfig[]
	 * @ORM\OneToMany(targetEntity="SellerInvoiceConfig", mappedBy="invoiceConfig", cascade={"all"})
	 */
	public $sellerInvoiceConfigs;

	public function __construct(int $maturity, NumericalSeries $numericalSeries, NumericalSeries $correctiveNumericalSeries)
	{
		$this->maturity                  = $maturity;
		$this->numericalSeries           = $numericalSeries;
		$this->correctiveNumericalSeries = $correctiveNumericalSeries;
		$this->sellerInvoiceConfigs      = new ArrayCollection();
	}

}
