<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * @ORM\Table("eshop_orders__order_card_payment_token")
 * @ORM\Entity
 */
class OrderCardPaymentToken
{
	use TId;

	/**
	 * @var Order
	 * @ORM\ManyToOne(targetEntity="Order")
	 * @ORM\JoinColumn(name="order_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public $order;

	/**
	 * @var string
	 * @ORM\Column(name="note", type="string", length=255, nullable=true)
	 */
	public $note;

	/**
	 * @var \DateTime
	 * @Gedmo\Timestampable(on="create")
	 * @ORM\Column(name="created", type="datetime")
	 */
	private $created;

	/**
	 * @var OrderCardPaymentHistory[]
	 * @ORM\OneToMany(targetEntity="OrderCardPaymentHistory", mappedBy="token")
	 */
	protected $history;

	/**
	 * @ORM\Column(name="param", type="string", nullable=true)
	 */
	public ?string $param = null;

	public function __construct(Order $order)
	{
		$this->order = $order;
	}

	public function getToken(string $type = 'id')
	{
		return $this->getId();
	}

	public function getCreated(): \DateTimeInterface { return $this->created; }

	public function getHistory() { return $this->history; }
}
