<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\Model\Entities\Product;
use Core\Model\Entities\TId;

/**
 * @ORM\Table("eshop_orders__order_gift")
 * @ORM\Entity
 */
class OrderGift
{
	use TId;

	/**
	 * @var Order
	 * @ORM\ManyToOne(targetEntity="Order", inversedBy="gifts")
	 * @ORM\JoinColumn(name="order_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected $order;

	/**
	 * @var Product
	 * @ORM\ManyToOne(targetEntity="EshopCatalog\Model\Entities\Product")
	 * @ORM\JoinColumn(name="product_id", referencedColumnName="id", onDelete="SET NULL")
	 */
	protected $product;

	/**
	 * @var string
	 * @ORM\Column(name="code1", type="string", length=60, nullable=true)
	 */
	public $code1;

	/**
	 * @var string
	 * @ORM\Column(name="ean", type="string", length=20, nullable=true)
	 */
	public $ean;

	/**
	 * @var string
	 * @ORM\Column(name="name", type="string", nullable=false)
	 */
	public $name;

	public function __construct(Order $order, Product $product, string $name)
	{
		$this->order   = $order;
		$this->product = $product;
		$this->name    = $name;
		$order->addGift($this);
	}

	public function getOrder(): Order { return $this->order; }

	public function getName(): string { return $this->name; }

	public function getProduct(): ?Product { return $this->product; }
}
