<?php declare(strict_types = 1);

namespace EshopOrders\Model\Helpers;

use EshopOrders\Model\EshopOrdersConfig;
use Nette\Forms\Controls\BaseControl;

class FormValidator
{
	public static ?Psc $pscHelper = null;

	public static function validateFormInput(BaseControl $input, $args): bool
	{
		if (!EshopOrdersConfig::load('orderForm.validatePsc') || !self::$pscHelper)
			return true;

		return self::$pscHelper->validatePsc((int) $input->getValue());
	}
}
