<?php declare(strict_types = 1);

namespace EshopOrders\Model;

use Core\Model\Helpers\BaseEntityService;
use EshopOrders\Model\Entities\Spedition;

/**
 * class Speditions
 * @package EshopOrders\Model
 *
 * @method Spedition|object|null getReference($id)
 * @method Spedition|null get($id)
 */
class Speditions extends BaseEntityService
{
	protected $entityClass = Spedition::class;

	public function getByIdent($ident)
	{
		$qb = $this->getEr()->createQueryBuilder('p');
		$qb->where('p.ident = :ident')
			->setParameter('ident', $ident);

		return $qb->getQuery()->getSingleResult();
	}

	public function getReferenceByIdent($ident)
	{
		return $this->getReference($this->getByIdent($ident)->getId());
	}
}
