<?php declare(strict_types = 1);

namespace EshopOrders\Model\Subscribers;

use Core\Model\Event\TemplateFactoryEvent;
use EshopCatalog\Model\Config;
use EshopOrders\FrontModule\Model\CartFacade;
use EshopOrders\FrontModule\Model\Customers;
use EshopOrders\Model\EshopOrdersConfig;
use EshopPackages\Model\EshopPackagesConfig;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class TemplateSubscriber implements EventSubscriberInterface
{
	protected Customers $customers;

	protected CartFacade $cartFacade;

	public function __construct(Customers $customers, CartFacade $cartFacade)
	{
		$this->customers  = $customers;
		$this->cartFacade = $cartFacade;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			'templateFactory::createTemplate' => 'createTemplate',
		];
	}

	public function createTemplate(TemplateFactoryEvent $event): void
	{
		$event->template->cart = $this->cartFacade->getCart();

		if (isset($event->template->user) && $event->template->user->isLoggedIn()) {

			$customer = $this->customers->getByUser($event->template->user->getIdentity());
			if ($customer) {
				$event->template->customer = $customer;

				if (EshopOrdersConfig::load('customer.allowShowPricesWithoutVat', false)
					&& isset($customer->getExtraFieldsValues()['showPricesWithoutVat']) && $customer->getExtraFieldsValues()['showPricesWithoutVat'] === '1') {

					EshopOrdersConfig::addParams([
						'cartPreview.showPriceWithoutVat'      => true,
						'orderForm.showPriceWithoutVat'        => true,
						'speditions.showPriceWithoutVatInCart' => true,
						'payments.showPriceWithoutVatInCart'   => true,
						'emails.showPriceWithoutVat'           => true,
					]);

					if (class_exists(Config::class))
						Config::addParams([
							'productPreview.basePriceWithoutVat' => true,
							'productDetail.basePriceWithoutVat'  => true,
						]);

					if (class_exists(EshopPackagesConfig::class))
						EshopPackagesConfig::addParams([
							'showPricesWithoutVat' => true,
						]);
				}
			}
		}

		if (!isset($event->template->customer))
			$event->template->customer = null;
	}
}
