document.addEventListener('change', e => {
	const target = e.target;

	if (target.id === 'invoiceAddressValidatedIdNumber') {
		global.naja.makeRequest('get', target.dataset.link.replace('__val__', target.checked ? 1 : 0), {}, {
			history: false,
			forceRedirect: true,
		});
	} else if (target.id === 'invoiceAddressValidatedVatNumber') {
		global.naja.makeRequest('get', target.dataset.link.replace('__val__', target.checked ? 1 : 0), {}, {
			history: false,
			forceRedirect: true,
		});
	}

	if (document.querySelector('[data-external-invoice-hint]')) {
		if (target.id === 'frm-orderStatusForm-form-status') {
			const choice = global.choicesList[document.querySelector('select#frm-orderStatusForm-form-status').dataset.choicesIndex]
			const externalInvoiceHint = document.querySelector('[data-external-invoice-hint]')
			externalInvoiceHint.style.display = ['spedition', 'finished'].includes(choice.getValue(true)) ? 'block' : 'none'
		}
	}
})

const initExpeditionForm = () => {
	const form = document.getElementById('frm-orderForm-expeditionForm')
	if (!form || form.dataset.ajaxInit) {
		return
	}

	form.dataset.ajaxInit = true

	form.addEventListener('submit', ev => {
		ev.preventDefault()
		if (!window.Nette.validateForm(form, false)) {
			return false
		}

		const event = new CustomEvent('orderForm:expeditionForm:submit', {detail: {form, submitForm: true}})
		document.dispatchEvent(event)

		if (event.detail.submitForm) {
			global.naja.uiHandler.submitForm(form, {forceRedirect: true})
		}
	})
}

document.addEventListener('DOMContentLoaded', e => {
	initExpeditionForm()
	global.naja.addEventListener('complete', initExpeditionForm)
	window.jQuery(document).ajaxComplete(function (event, xhr, settings) {
		initExpeditionForm()
	})
})