<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Components\Order;

use Core\Model\Application\AppState;
use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use EshopOrders\Model\Entities\Order;
use Nette\Utils\ArrayHash;

class IsPaidSwitch extends BaseControl
{
	protected Order $order;

	public function __construct(
		Order $order
	)
	{
		$this->order = $order;
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm(): BaseForm
	{
		$form = $this->createForm();
		$form->setAjax();

		$form->addBool('isPaid', '')
			->setDefaultValue($this->order->isPaid)
			->setHtmlAttribute('onchange', 'window.naja.uiHandler.submitForm(this.form)');

		$form->onSuccess[] = function(BaseForm $form, ArrayHash $values) {
			AppState::setState('eshopOrdersPaymentMethod', 'eshopOrders.paymentMethod.manual');
			$this->order->isPaid = (int) $values->isPaid;
			$this->em->persist($this->order);
			$this->em->flush();

			$this->redrawControl('form');

			$parent = $this->lookup(BaseControl::class, false);
			if ($parent && method_exists($parent, 'redrawControl')) {
				$parent->redrawControl('isPaidWrap');
			}
		};

		return $form;
	}
}
