<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use EshopOrders\FrontModule\Model\EshopOrdersCache;
use EshopOrders\Model\Entities\Affiliate\AffiliateCampaign;

/**
 * @method AffiliateCampaign|object|null getReference($id)
 * @method AffiliateCampaign[] getAll($id)
 * @method AffiliateCampaign|null get($id)
 */
class AffiliateCampaigns extends BaseEntityService
{
	protected $entityClass = AffiliateCampaign::class;

	protected EshopOrdersCache $eshopOrdersCache;

	protected ?array $cForSelectOption = null;

	public function __construct(
		EshopOrdersCache $eshopOrdersCache
	)
	{
		$this->eshopOrdersCache = $eshopOrdersCache;
	}

	public function getForSelectOption(): array
	{
		if ($this->cForSelectOption === null) {
			$this->cForSelectOption = $this->getEr()->findPairs([], 'name') ?: [];
		}

		return $this->cForSelectOption;
	}

	public function remove($id)
	{
		$result = parent::remove($id);

		$this->eshopOrdersCache->cleanAffiliate();

		return $result;
	}

}
