<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use EshopOrders\FrontModule\Model\EshopOrdersCache;
use EshopOrders\Model\Entities\Affiliate\AffiliateOrder;

/**
 * @method AffiliateOrder|object|null getReference($id)
 * @method AffiliateOrder[] getAll($id)
 * @method AffiliateOrder|null get($id)
 */
class AffiliateOrders extends BaseEntityService
{
	protected $entityClass = AffiliateOrder::class;

	protected EshopOrdersCache $eshopOrdersCache;

	public function __construct(
		EshopOrdersCache $eshopOrdersCache
	)
	{
		$this->eshopOrdersCache = $eshopOrdersCache;
	}
}
