<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Helpers;

use EshopOrders\FrontModule\Model\Dao\Cart;
use EshopOrders\Model\Entities\Customer;
use EshopOrders\Model\EshopOrdersConfig;

class CustomerHelper
{
	public static function checkCustomerMultipleQuantitiesInCart(Customer $customer, Cart $cart): int
	{
		$group = $customer->getGroupCustomers();
		if ($group && $group->multipleToOrder && EshopOrdersConfig::load('customerGroup.allowMultipleToOrder')) {
			$tmp =  $cart->getTotalQuantity() % $group->multipleToOrder;

			if ($tmp === 0) {
				return 0;
			}

			return $group->multipleToOrder - $tmp;
		}

		return 0;
	}
}
