<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model;

use Nette\Caching\Cache;
use Nette\Caching\Storage;

class EshopOrdersCache
{
	public const partnersKey  = 'partners';
	public const campaignsKey = 'campaigns';

	protected Storage $storage;

	protected ?Cache $affiliateCache = null;

	public function __construct(
		Storage $storage
	)
	{
		$this->storage = $storage;
	}

	public function getAffiliateCache(): Cache
	{
		if ($this->affiliateCache === null) {
			$this->affiliateCache = new Cache($this->storage, 'eshopOrdersAffiliate');
		}

		return $this->affiliateCache;
	}

	public function cleanAffiliate(): void
	{
		$affiliateCache = $this->getAffiliateCache();

		$affiliateCache->remove(self::partnersKey);
		$affiliateCache->remove(self::campaignsKey);
		$affiliateCache->remove('affiliateBase');
	}
}
