<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model\Event;

use EshopOrders\FrontModule\Model\Dao\Payment;
use EshopOrders\FrontModule\Model\Dao\Spedition;
use Symfony\Contracts\EventDispatcher\Event;

class PaymentsSpeditionsEvent extends Event
{
	/** @var Payment[]|null */
	public ?array $payments;

	/** @var Spedition[]|null */
	public ?array $speditions;

	public function __construct(
		?array $payments,
		?array $speditions
	)
	{
		$this->payments   = $payments;
		$this->speditions = $speditions;
	}
}
