<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model;

use Core\Model\Helpers\BaseFrontEntityService;
use Doctrine\ORM\Query\Expr\Join;
use EshopCatalog\Model\Config;
use EshopCatalog\Model\Entities\ProductAssignCustomer;

class ProductsAssignedToCustomers extends BaseFrontEntityService
{
	/** @var string */
	protected $entityClass = ProductAssignCustomer::class;

	public function getProductsIdByUser(int $userId): array
	{
		return Config::load('product.allowAssignProductToCustomer')
			? array_map(
				static fn($v) => $v['id'],
				$this->getEr()->createQueryBuilder('pc')
					->select('IDENTITY(pc.product) as id')
					->innerJoin('pc.customer', 'c', Join::WITH, 'c.user = :user')
					->setParameter('user', $userId)
					->getQuery()->getArrayResult()
			)
			: [];
	}
}
