<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities\Invoice;

use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table("eshop_orders__invoice_customer")
 * @ORM\Entity
 */
class Customer
{
	use TId;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $firstName = null;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $lastName = null;

	/**
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	public ?string $email = null;

	/**
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	public ?string $phone = null;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $company = null;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $idNumber = null;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $vatNumber = null;

	/**
	 * @ORM\Column(name="id_vat_number", type="string", length=255, nullable=true)
	 */
	public ?string $idVatNumber = null;

	/**
	 * @ORM\Column(name="validated_id_number", type="smallint", length=1, options={"default": 0})
	 */
	public int $validatedIdNumber = 0;

	/**
	 * @ORM\Column(name="validated_vat_number", type="smallint", length=1, options={"default": 0})
	 */
	public int $validatedVatNumber = 0;

	/**
	 * @ORM\OneToOne(targetEntity="Address", cascade={"persist"})
	 * @ORM\JoinColumn(name="address_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public Address $address;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $customNumber = null;

	public function __construct(Address $address)
	{
		$this->address = $address;
	}

	public function getAddress(): Address { return $this->address; }

	public function getName(): string { return trim($this->firstName . ' ' . $this->lastName); }
}
