<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * @ORM\Table("eshop_orders__order_card_payment_history")
 * @ORM\Entity
 */
class OrderCardPaymentHistory
{
	use TId;

	public const STATUS_CREATED   = 'created';
	public const STATUS_CHECKOUT  = 'checkout';
	public const STATUS_ERROR     = 'error';
	public const STATUS_CANCELLED = 'cancelled';
	public const STATUS_PENDING   = 'pending';
	public const STATUS_PAID      = 'paid';

	/**
	 * @ORM\ManyToOne(targetEntity="OrderCardPaymentToken")
	 * @ORM\JoinColumn(name="token_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public OrderCardPaymentToken $token;

	/**
	 * @ORM\Column(name="status", type="string", length=255, nullable=false)
	 */
	protected string $status;

	/**
	 * @ORM\Column(name="note", type="string", length=255, nullable=true)
	 */
	public ?string $note = null;

	/**
	 * @Gedmo\Timestampable(on="create")
	 * @ORM\Column(name="created", type="datetime")
	 */
	private \DateTime $created;

	public function __construct(OrderCardPaymentToken $token, string $status)
	{
		$this->token   = $token;
		$this->status  = $status;
		$this->created = new \DateTime();
	}

	public function getStatus(): string { return $this->status; }

	public function getCreated(): \DateTime { return $this->created; }
}
