<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\Model\Entities\Product;
use EshopOrders\Model\Entities\Attributes\IsReadyToDelivery;

/**
 * @ORM\Table("eshop_orders__order_gift")
 * @ORM\Entity
 */
class OrderGift implements IOrderItem
{
	use TId;
	use IsReadyToDelivery;

	/**
	 * @ORM\ManyToOne(targetEntity="Order", inversedBy="gifts")
	 * @ORM\JoinColumn(name="order_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected Order $order;

	/**
	 * @ORM\ManyToOne(targetEntity="EshopCatalog\Model\Entities\Product")
	 * @ORM\JoinColumn(name="product_id", referencedColumnName="id", onDelete="SET NULL")
	 */
	protected ?Product $product = null;

	/**
	 * @ORM\Column(name="code1", type="string", length=60, nullable=true)
	 */
	public ?string $code1 = null;

	/**
	 * @ORM\Column(name="ean", type="string", length=20, nullable=true)
	 */
	public ?string $ean = null;

	/**
	 * @ORM\Column(name="name", type="string", nullable=false)
	 */
	public string $name;

	public function __construct(Order $order, Product $product, string $name)
	{
		$this->order   = $order;
		$this->product = $product;
		$this->name    = $name;
		$order->addGift($this);
	}

	public function getOrder(): Order { return $this->order; }

	public function getName(): string { return $this->name; }

	public function getProduct(): ?Product { return $this->product; }

	public function getProductId(): ?int { return $this->product ? $this->product->getId() : null; }

	public function getQuantity(): int { return 1; }

	public function getDefaultQuantity(): int { return $this->getQuantity(); }
}
