<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;
use Nette\Utils\DateTime;
use Users\Model\Entities\User;

/**
 * @ORM\Table("eshop_orders__order_history")
 * @ORM\Entity
 */
class OrderHistory
{
	use TId;

	/**
	 * @ORM\ManyToOne(targetEntity="Order")
	 * @ORM\JoinColumn(name="order_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected Order $order;

	/**
	 * @ORM\Column(type="string", length=255, nullable=false)
	 */
	public string $text;

	/**
	 * @ORM\Column(name="created", type="datetime", options={"default": "CURRENT_TIMESTAMP"})
	 */
	protected \DateTime $created;

	/**
	 * @ORM\ManyToOne(targetEntity="\Users\Model\Entities\User")
	 * @ORM\JoinColumn(name="created_by", referencedColumnName="id", onDelete="SET NULL")
	 */
	protected ?User $createdBy = null;

	public function __construct(Order $order, string $text, ?User $createdBy = null)
	{
		$this->order     = $order;
		$this->text      = $text;
		$this->createdBy = $createdBy;
		$this->created   = new DateTime;
	}

	public function getOrder(): Order { return $this->order; }

	public function getCreated(): \DateTime { return $this->created; }

	public function getCreatedBy(): ?User { return $this->createdBy; }
}
