<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\Model\Entities\Product;
use Core\Model\Entities\TId;

/**
 * @ORM\Table("eshop_orders__order_item_gift")
 * @ORM\Entity
 */
class OrderItemGift implements IOrderItem
{
	use TId;

	/**
	 * @ORM\ManyToOne(targetEntity="OrderItem", inversedBy="gifts")
	 * @ORM\JoinColumn(name="order_item_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected OrderItem $orderItem;

	/**
	 * @ORM\ManyToOne(targetEntity="EshopCatalog\Model\Entities\Product")
	 * @ORM\JoinColumn(name="product_id", referencedColumnName="id", onDelete="SET NULL")
	 */
	protected ?Product $product = null;

	/**
	 * @ORM\Column(name="code1", type="string", length=60, nullable=true)
	 */
	public ?string $code1 = null;

	/**
	 * @ORM\Column(name="ean", type="string", length=20, nullable=true)
	 */
	public ?string $ean = null;

	/**
	 * @ORM\Column(name="name", type="string", nullable=false)
	 */
	protected string $name;

	public function __construct(OrderItem $orderItem, Product $product, string $name)
	{
		$this->orderItem = $orderItem;
		$this->product   = $product;
		$this->name      = $name;
		$orderItem->addGift($this);
	}

	public function getOrderItem(): OrderItem { return $this->orderItem; }

	public function getProduct(): ?Product { return $this->product; }

	public function getName(): string { return $this->name; }

	public function getQuantity(): int { return 1; }

	public function getOrder(): Order { return $this->getOrderItem()->getOrder(); }

	public function getProductId(): ?int { return $this->getProduct() ? $this->getProduct()->getId() : null; }

	public function getDefaultQuantity(): int { return $this->getQuantity(); }
}
