<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Core\Model\Entities\Country;
use Core\Model\Entities\Site;
use Core\Model\Entities\TId;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * @ORM\Table("eshop_orders__payment_spedition")
 * @ORM\Entity
 */
class PaymentSpedition
{
	use TId;

	/**
	 * @ORM\ManyToOne(targetEntity="Payment")
	 * @ORM\JoinColumn(name="payment_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected Payment $payment;

	/**
	 * @ORM\ManyToOne(targetEntity="Spedition")
	 * @ORM\JoinColumn(name="spedition_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected Spedition $spedition;

	/**
	 * @ORM\Column(name="is_published", type="smallint")
	 */
	public int $isPublished = 0;

	/**
	 * @Gedmo\SortablePosition
	 * @ORM\Column(name="position", type="integer")
	 */
	protected int $position = 0;

	/**
	 * @var ArrayCollection<Site>
	 * @ORM\ManyToMany(targetEntity="Core\Model\Entities\Site", indexBy="ident")
	 * @ORM\JoinTable(name="eshop_orders__payment_spedition_site",
	 *     joinColumns={@ORM\JoinColumn(name="ps_id", referencedColumnName="id", onDelete="CASCADE")},
	 *     inverseJoinColumns={@ORM\JoinColumn(name="site_id", referencedColumnName="ident", onDelete="CASCADE")}
	 *     )
	 */
	public Collection $sites;

	/**
	 * @var ArrayCollection<Country>
	 * @ORM\ManyToMany(targetEntity="Core\Model\Entities\Country", indexBy="id")
	 * @ORM\JoinTable(name="eshop_orders__payment_spedition_country",
	 *     joinColumns={@ORM\JoinColumn(name="ps_id", referencedColumnName="id", onDelete="CASCADE")},
	 *     inverseJoinColumns={@ORM\JoinColumn(name="country_id", referencedColumnName="id", onDelete="CASCADE")}
	 *     )
	 */
	public Collection $countries;

	/**
	 * @var ArrayCollection<GroupCustomers>
	 * @ORM\ManyToMany(targetEntity="GroupCustomers", indexBy="id")
	 * @ORM\JoinTable(name="eshop_orders__payment_spedition_customer_group",
	 *     joinColumns={@ORM\JoinColumn(name="ps_id", referencedColumnName="id", onDelete="CASCADE")},
	 *     inverseJoinColumns={@ORM\JoinColumn(name="group_id", referencedColumnName="id", onDelete="CASCADE")}
	 *     )
	 */
	public Collection $customerGroups;

	/**
	 * @ORM\Column(name="customer_without_group", type="smallint", options={"unsigned": true, "default": 0})
	 */
	public int $customerWithoutGroup = 0;

	/**
	 * @ORM\Column(name="no_customer", type="smallint", options={"unsigned": true, "default": 0})
	 */
	public int $noCustomer = 0;

	/**
	 * @ORM\Column(name="currency", type="string", nullable=true)
	 */
	public ?string $currency = null;

	/**
	 * @ORM\Column(name="free_from_date", type="datetime", nullable=true)
	 */
	public ?\DateTime $freeFromDate = null;

	/**
	 * @ORM\Column(name="free_to_date", type="datetime", nullable=true)
	 */
	public ?\DateTime $freeToDate = null;

	public function __construct()
	{
		$this->isPublished = 1;
		$this->setPosition(-1);
		$this->countries      = new ArrayCollection();
		$this->sites          = new ArrayCollection();
		$this->customerGroups = new ArrayCollection();
	}

	public function getPayment(): Payment { return $this->payment; }

	public function setPayment(Payment $payment): PaymentSpedition
	{
		$this->payment = $payment;

		return $this;
	}

	public function getSpedition(): Spedition { return $this->spedition; }

	public function setSpedition(Spedition $spedition): PaymentSpedition
	{
		$this->spedition = $spedition;

		return $this;
	}

	public function getPosition(): int { return $this->position; }

	public function setPosition(int $position): PaymentSpedition
	{
		$this->position = $position;

		return $this;
	}
}
