<?php declare(strict_types = 1);

namespace EshopOrders\Model\Listeners;

use Core\Model\Entities\EntityManagerDecorator;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use EshopOrders\Model\Entities\Customer;
use EshopOrders\Model\Entities\CustomerAddress;
use Nette\Utils\DateTime;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class UserListener implements EventSubscriberInterface
{
	protected EntityManagerDecorator $em;

	public function __construct(
		EntityManagerDecorator $em
	)
	{
		$this->em = $em;
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	/**
	 * @ORM\PostUpdate
	 *
	 * @param Customer|CustomerAddress $entity
	 */
	public function preUpdate(object $entity, LifecycleEventArgs $args): void
	{
		$userIds = [];
		if ($entity instanceof Customer) {
			$userId[] = $entity->user->getId();
		} else if ($entity instanceof CustomerAddress) {
			foreach ($entity->customers as $c) {
				$userIds[] = $c->user->getId();
			}
		}

		if (!empty($userIds)) {
			$this->em->getConnection()->executeQuery(
				"UPDATE user SET last_modified = :datetime WHERE id IN (" . implode(',', $userIds) . ")", [
				'datetime' => (new DateTime())->format('Y-m-d H:i:s'),
			]);
		}
	}
}
