<?php declare(strict_types = 1);

namespace EshopOrders\Model;

use Core\Model\Helpers\BaseEntityService;
use EshopOrders\Model\Entities\Spedition;

/**
 * @method Spedition getReference($id)
 * @method Spedition|null get($id)
 */
class Speditions extends BaseEntityService
{
	protected $entityClass = Spedition::class;

	public function getByIdent(string $ident): ?Spedition
	{
		$qb = $this->getEr()->createQueryBuilder('p');
		$qb->where('p.ident = :ident')
			->setParameter('ident', $ident);

		return $qb->getQuery()->getSingleResult();
	}
}
