if (!global.document.autocompleteResultItem)
	global.document.autocompleteResultItem = {};

global.document.autocompleteResultItem['orderItemAddForm-product'] = (data, source) => {
	source.innerHTML = data.value.code1 + ' | ' + data.value.name;
};

document.addEventListener('autocompleteOnSelection', e => {
	if (e.detail.name == "orderItemAddForm-product") {
		const input = document.querySelector('[data-autocomplete-name="' + e.detail.name + '"]');
		const form  = document.querySelector('.orderItemAddForm');
		const data  = e.detail.selection.value;

		if (form) {
			form.querySelector('[name="code1"]').value   = data.code1;
			form.querySelector('[name="vatRate"]').value = data.vatRate;

			global.naja.makeRequest('get', input.dataset.detailLink.replace('__id__', data.id), {}, {
				history: false,
			}).then(response => {
				form.querySelector('[name="price"]').value = response.price;
			});
		}
	}
})
