<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Components\DashboardWidgets;

use Dashboard\AdminModule\Model\Provider\IWidget;
use EshopOrders\AdminModule\Model\Statistics;
use Nette\Utils\DateTime;

class MonthlyOrders extends BaseEshopOrdersWidget implements IWidget
{
	protected string $gridSize = 'col-md-8 col-xxl-6';

	protected string $key = 'eshopOrdersMonthlyOrders';

	/** @var Statistics\Statistics|null @inject */
	public ?Statistics\Statistics $statistics = null;

	public function __construct()
	{
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentGrid()
	{
		$grid = $this->createGrid();

		$to = new DateTime();
		$from = (new DateTime())
			->modify('first day of this month')
			->modify('-2 months')
			->setTime(0, 0, 0);

		$grid->setDataSource($this->statistics->getMonthly($from, $to));

		$grid->addColumnDateTime('date', 'eshopOrders.dashboardWidget.monthlyOrders.date')->setFormat('Y-m');
		$grid->addColumnNumber('orders', 'eshopOrders.dashboardWidget.monthlyOrders.ordersCount')->setFormat(0, '', ' ');
		$grid->addColumnNumber('ordersPrice', 'eshopOrders.dashboardWidget.monthlyOrders.ordersPrice')->setRenderer(function(array $row) {
			return $this->priceFilter->format((float) $row['ordersPrice']);
		});

		return $grid;
	}
}
