<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Components\Order;

use Core\Model\Helpers\Strings;
use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use Nette\Utils\ArrayHash;
use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\Entities\OrderPayment;
use EshopOrders\Model\Orders;
use EshopOrders\Model\Payments;

class OrderPaymentForm extends BaseControl
{
	/** @var int @persistent */
	public $orderPaymentId;

	/** @var OrderPayment */
	public $orderPayment;

	/** @var Order */
	public $order;

	/** @var Orders */
	protected $ordersService;

	/** @var Payments */
	protected $paymentsService;

	public function __construct(Orders $orders, Payments $payments)
	{
		$this->ordersService   = $orders;
		$this->paymentsService = $payments;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	/*******************************************************************************************************************
	 * ======================== Components
	 */

	protected function createComponentForm()
	{
		$form = $this->createForm();

		$payments    = $this->paymentsService->getAll();
		$paymentList = [];
		foreach ($payments as $payment) {
			$paymentList[$payment->getId()] = $payment->getName() . ' (cena ' . $payment->getPrice() . ' Kč)';
		}

		$form->addSelect('payment', 'eshopOrders.default.payment', $paymentList);
		$form->addText('price', 'eshopOrders.default.paymentPrice');

		$form->addSaveCancelControl();
		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
		try {
			$order        = $this->order;
			$orderPayment = $this->order->getPayment();
			$newPayment   = $this->paymentsService->get($values->payment);

			bdump((float) Strings::formatEntityDecimal($values->price));
			$orderPayment->setPrice((float) Strings::formatEntityDecimal($values->price));
			if (!$orderPayment->getPayment() || $orderPayment->getPayment()->getId() != $newPayment->getId()) {
				$orderPayment->setName($newPayment->getName());
				$orderPayment->setPayment($newPayment);
			}
			$this->em->persist($orderPayment)->flush();

			$this->getPresenter()->flashMessageSuccess('eshopOrders.orderPaymentForm.edited');
		} catch (\Exception $e) {
			$form->addError($e->getMessage());
			$this->redrawControl('form');

			return false;
		}
	}

	public function setOrder($orderId)
	{
		$this->order        = $this->ordersService->get($orderId);
		$this->orderPayment = $this->order->getPayment();

		if ($this->orderPayment) {
			$i = $this->orderPayment;

			$defaults = ['price' => $i->getPrice()];
			if ($i->getPayment()) {
				$defaults['payment'] = $i->getPayment()->getId();
			}
			$this['form']->setDefaults($defaults);
		}
	}
}
