<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Presenters;

use EshopOrders\AdminModule\Model\DataConverter;
use EshopOrders\AdminModule\Model\Orders;
use EshopOrders\AdminModule\Model\Pdfs;
use EshopOrders\Model\EshopOrdersConfig;
use EshopOrders\Model\Pdf\IDeliveryListPdfBuilderFactory;
use EshopOrders\Model\Pdf\IInvoicePdfBuilderFactory;
use Nette\Application\ForbiddenRequestException;

class OrdersPresenter extends BasePresenter
{
	/** @var DataConverter|null @inject */
	public ?DataConverter $dataConverter = null;

	/** @var Orders|null @inject */
	public ?Orders $ordersService = null;

	/** @var IDeliveryListPdfBuilderFactory|null @inject */
	public ?IDeliveryListPdfBuilderFactory $deliveryListBuilder = null;

	/** @var IInvoicePdfBuilderFactory|null @inject */
	public ?IInvoicePdfBuilderFactory $invoicePdfBuilder = null;

	protected function startup()
	{
		parent::startup();
	}

	/*******************************************************************************************************************
	 * ==================  Handle
	 */

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault(): void
	{
		$this['navigation']->setData(['header' => [

		]]);
	}

	public function actionInvoice(int $orderId): void
	{
		$order = $this->ordersService->get($orderId);

		if (!$order)
			throw new ForbiddenRequestException();

		$invoice = $this->invoices->getOneByOrder($order, true);

		$this->invoicePdfBuilderFactory->create($invoice)->render();
	}

	public function actionPrint(array $ids): void
	{
		$data = $this->dataConverter->forPrint($ids);

		$this->template->statuses = $data['statuses'];
		$this->template->orders   = $data['orders'];
		$this->template->vatTotal = $data['vatTotal'];
	}

	public function actionPrintDeliveryList(array $ids): void
	{
		if (!EshopOrdersConfig::load('enableDeliveryListPrint'))
			throw new ForbiddenRequestException();
		$this->deliveryListBuilder->create($ids)->render();
		$this->terminate();
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

}
