<?php declare(strict_types = 1);

namespace EshopOrders\ApiModule\Api\V1\Controllers;

use Apitte\Core\Annotation\Controller\Method;
use Apitte\Core\Annotation\Controller\Path;
use Apitte\Core\Http\ApiRequest;
use Apitte\Core\Http\ApiResponse;
use Apitte\Negotiation\Http\ArrayEntity;
use EshopOrders\AdminModule\Model\Customers;
use Users\Model\Security\User;

/**
 * Class CustomersController
 * @Path("/customers")
 */
class CustomersController extends BaseController
{
	/** @var User */
	protected $user;

	/** @var Customers */
	protected $customersService;

	public function __construct(User $userService, Customers $customersService)
	{
		$this->user             = $userService;
		$this->customersService = $customersService;
	}

	/**
	 * @Path("/")
	 * @Method("GET")
	 */
	public function index(ApiRequest $request, ApiResponse $response)
	{
		$qb        = $this->customersService->getEr()->createQueryBuilder('p')
			->addSelect('user, adDel, adInv, grp')
			->innerJoin('p.user', 'user')
			->leftJoin('p.addressDelivery', 'adDel')
			->leftJoin('p.addressInvoice', 'adInv')
			->leftJoin('p.groupCustomers', 'grp');
		$customers = $qb->getQuery()->getResult();

		return $response->withStatus(ApiResponse::S200_OK)->withEntity(ArrayEntity::from($customers));
	}

	/**
	 * @Path("/search")
	 * @Method("POST")
	 */
	public function search(ApiRequest $request, ApiResponse $response)
	{
		$term = $request->getJsonBody()['term'];

		$qb        = $this->customersService->getEr()->createQueryBuilder('p')
			->addSelect('user, adDel, adInv, grp, p.id')
			->innerJoin('p.user', 'user')
			->leftJoin('p.addressDelivery', 'adDel')
			->leftJoin('p.addressInvoice', 'adInv')
			->leftJoin('p.groupCustomers', 'grp')
			->andWhere('user.name LIKE :term OR user.lastname LIKE :term OR user.email LIKE :term')
			->setParameter('term', $term);
		$customers = $qb->getQuery()->getResult();

		return $response->withStatus(ApiResponse::S200_OK)->withEntity(ArrayEntity::from($customers));
	}
}
