<?php declare(strict_types = 1);

namespace EshopOrders\CronModule\Presenters;

use EshopOrders\Model\EshopOrdersConfig;
use EshopOrders\Model\Orders;

class DefaultPresenter extends BasePresenter
{
	/** @var Orders @inject */
	public ?Orders $ordersService = null;

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionSendSurvey()
	{
		$config = EshopOrdersConfig::load('sendSurveyAfterOrder');
		if ($config === false)
			$this->terminate();

		foreach ($this->ordersService->getOrdersWithoutSurveySent($config) as $order)
			$this->ordersService->sendSurvey($order);
		$this->terminate();
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

}
