<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities\Invoice;

use Doctrine\ORM\Mapping as ORM;
use Core\Model\Entities\TId;

/**
 * @ORM\Table("eshop_orders__invoice_payment")
 * @ORM\Entity
 */
class Payment
{
	use TId;

	/**
	 * @var string
	 * @ORM\Column(type="integer", options={"unsigned": true})
	 */
	public $paymentId;

	/**
	 * @var string
	 * @ORM\Column(type="string")
	 */
	public $name;

	/**
	 * @var float
	 * @ORM\Column(type="decimal", precision=10, scale=2)
	 */
	protected $price;

	/**
	 * @var InvoiceData
	 * @ORM\OneToOne(targetEntity="InvoiceData", mappedBy="payment")
	 */
	public $invoiceData;

	public function setPrice($price) { $this->price = $price; }

	public function getPrice(): float
	{
		return (float) $this->price;
	}

	public function getPriceWithoutVat(): float
	{
		$vatRate = $this->invoiceData ? $this->invoiceData->getPaySpedVatRate() : 21;

		if ($vatRate == 0)
			return (float) $this->price;

		$vatRate = ($vatRate / 100) + 1;

		return round((float) $this->price / $vatRate, 2);
	}
}
