<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Core\Model\Entities\Country;
use Core\Model\Entities\Site;
use Currency\Model\Entities\Currency;
use DateTimeInterface;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Core\Model\Entities\TId;

/**
 * @ORM\Table("eshop_orders__payment_spedition")
 * @ORM\Entity
 */
class PaymentSpedition
{
	use TId;

	/**
	 * @var Payment
	 * @ORM\ManyToOne(targetEntity="Payment")
	 * @ORM\JoinColumn(name="payment_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected $payment;

	/**
	 * @var Spedition
	 * @ORM\ManyToOne(targetEntity="Spedition")
	 * @ORM\JoinColumn(name="spedition_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected $spedition;

	/**
	 * @var int
	 * @ORM\Column(name="is_published", type="smallint")
	 */
	public $isPublished;

	/**
	 * @var int
	 * @Gedmo\SortablePosition
	 * @ORM\Column(name="position", type="integer")
	 */
	protected $position;

	/**
	 * @var Site[]
	 * @ORM\ManyToMany(targetEntity="Core\Model\Entities\Site", indexBy="ident")
	 * @ORM\JoinTable(name="eshop_orders__payment_spedition_site",
	 *     joinColumns={@ORM\JoinColumn(name="ps_id", referencedColumnName="id", onDelete="CASCADE")},
	 *     inverseJoinColumns={@ORM\JoinColumn(name="site_id", referencedColumnName="ident", onDelete="CASCADE")}
	 *     )
	 */
	public $sites;

	/**
	 * @var Country[]
	 * @ORM\ManyToMany(targetEntity="Core\Model\Entities\Country", indexBy="id")
	 * @ORM\JoinTable(name="eshop_orders__payment_spedition_country",
	 *     joinColumns={@ORM\JoinColumn(name="ps_id", referencedColumnName="id", onDelete="CASCADE")},
	 *     inverseJoinColumns={@ORM\JoinColumn(name="country_id", referencedColumnName="id", onDelete="CASCADE")}
	 *     )
	 */
	public $countries;

	/**
	 * @ORM\Column(name="currency", type="string", nullable=true)
	 */
	public ?string $currency = null;

	/**
	 * @var DateTimeInterface|null
	 * @ORM\Column(name="free_from_date", type="datetime", nullable=true)
	 */
	public ?DateTimeInterface $freeFromDate = null;

	/**
	 * @var DateTimeInterface|null
	 * @ORM\Column(name="free_to_date", type="datetime", nullable=true)
	 */
	public ?DateTimeInterface $freeToDate = null;

	public function __construct()
	{
		$this->isPublished = 1;
		$this->setPosition(-1);
		$this->countries = new ArrayCollection();
		$this->sites     = new ArrayCollection();
	}

	/**
	 * @return Payment
	 */
	public function getPayment(): Payment
	{
		return $this->payment;
	}

	/**
	 * @param Payment $payment
	 *
	 * @return PaymentSpedition
	 */
	public function setPayment(Payment $payment): PaymentSpedition
	{
		$this->payment = $payment;

		return $this;
	}

	/**
	 * @return Spedition
	 */
	public function getSpedition(): Spedition
	{
		return $this->spedition;
	}

	/**
	 * @param Spedition $spedition
	 *
	 * @return PaymentSpedition
	 */
	public function setSpedition(Spedition $spedition): PaymentSpedition
	{
		$this->spedition = $spedition;

		return $this;
	}

	/**
	 * @return int
	 */
	public function getPosition(): int
	{
		return $this->position;
	}

	/**
	 * @param int $position
	 *
	 * @return PaymentSpedition
	 */
	public function setPosition(int $position): PaymentSpedition
	{
		$this->position = $position;

		return $this;
	}
}
