<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Core\Model\Helpers\Strings;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity
 * @ORM\Table(name="eshop_orders__spedition_price_level")
 */
class SpeditionPriceLevel
{

	/**
	 * @var Spedition
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Spedition", inversedBy="priceLevels", cascade={"persist", "remove"})
	 * @ORM\JoinColumn(name="spedition_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	private Spedition $spedition;

	/**
	 * @var GroupCustomers
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="GroupCustomers")
	 * @ORM\JoinColumn(name="group_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	private GroupCustomers $group;

	/**
	 * @var double
	 * @ORM\Column(name="price", type="decimal", precision=10, scale=2, nullable=false)
	 */
	protected $price;

	/**
	 * @var int
	 * @ORM\Column(name="free_from", type="integer", nullable=true)
	 */
	public ?int $freeFrom = null;

	/**
	 * @var int
	 * @ORM\Column(name="available_from", type="integer", nullable=true)
	 */
	public ?int $availableFrom = null;

	/**
	 * @var int
	 * @ORM\Column(name="available_to", type="integer", nullable=true)
	 */
	public ?int $availableTo = null;

	public function __construct(Spedition $spedition, GroupCustomers $group, float $price)
	{
		$this->spedition = $spedition;
		$this->group     = $group;
		$this->setPrice($price);
	}

	/**
	 * @return Spedition
	 */
	public function getSpedition(): Spedition { return $this->spedition; }

	/**
	 * @return GroupCustomers
	 */
	public function getGroup(): GroupCustomers { return $this->group; }

	/**
	 * @return float
	 */
	public function getPrice(): float { return (float) $this->price; }

	/**
	 * @param float $price
	 */
	public function setPrice(float $price): void
	{
		$this->price = Strings::formatEntityDecimal($price);
	}
}
