<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Core\Model\Entities\TId;

/**
 * @ORM\Table("eshop_orders__status")
 * @ORM\Entity
 */
class Status
{
	
	/**
	 * @var string
	 * @ORM\Id
	 * @ORM\Column(name="id", type="string")
	 */
	protected $id;
	
	/**
	 * @var string
	 * @ORM\Column(name="name", type="string")
	 */
	protected $name;
	
	/** Poradi pro zobrazeni v adminu - chronologicky
	 * @var int
	 * @Gedmo\SortablePosition
	 * @ORM\Column(name="position", type="integer")
	 */
	protected $position;
	
	/**
	 * Status constructor.
	 * @param string $id (anglicky, bez hacku a carek)
	 * @param string $name
	 */
	public function __construct(string $id, string $name)
	{
		$this->id   = $id;
		$this->name = $name;
		$this->setPosition(-1);
	}
	
	/**
	 * @return string
	 */
	public function getId(): string
	{
		return $this->id;
	}
	
	/**
	 * @param string $id
	 * @return Status
	 */
	public function setId(string $id): Status
	{
		$this->id = $id;
		return $this;
	}
	
	/**
	 * @return string
	 */
	public function getName(): string
	{
		return $this->name;
	}
	
	/**
	 * @param string $name
	 * @return Status
	 */
	public function setName(string $name): Status
	{
		$this->name = $name;
		return $this;
	}
	
	/**
	 * @return int
	 */
	public function getPosition(): int
	{
		return $this->position;
	}
	
	/**
	 * @param int $position
	 * @return Status
	 */
	public function setPosition(int $position): Status
	{
		$this->position = intval($position);
		return $this;
	}
	
}
