<?php declare(strict_types = 1);

namespace EshopOrders\Model\Subscribers;

use Core\Model\Event\TemplateFactoryEvent;
use EshopOrders\FrontModule\Model\CartFacade;
use EshopOrders\FrontModule\Model\Customers;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class TemplateSubscriber implements EventSubscriberInterface
{
	protected Customers $customers;

	protected CartFacade $cartFacade;

	public function __construct(Customers $customers, CartFacade $cartFacade)
	{
		$this->customers = $customers;
		$this->cartFacade = $cartFacade;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			'templateFactory::createTemplate' => 'createTemplate',
		];
	}

	public function createTemplate(TemplateFactoryEvent $event): void
	{
		$event->template->cart = $this->cartFacade->getCart();

		if (isset($event->template->user) && $event->template->user->isLoggedIn()) {

			$customer = $this->customers->getByUser($event->template->user->getIdentity());
			if ($customer)
				$event->template->customer = $customer;
		}

		if (!isset($event->template->customer))
			$event->template->customer = null;
	}
}
