const update = () => {
	setTimeout(e => {
		if (!document.querySelector('.show-details .fa-angle-up')) {
			global.naja.makeRequest('get', '?do=update', [], {
				history: false,
			});
			update();
		}
	}, 60000);
}

setTimeout(e => {
	update();
}, 5000);

document.addEventListener('click', e => {
	let target = e.target;

	const clickedButton = target.matches('.show-details');

	if (clickedButton || target.closest('.show-details')) {
		e.preventDefault();

		if (!clickedButton)
			target = target.closest('.show-details');

		const textMore = target.dataset.showText;
		const textHide = target.dataset.hideText;
		const classShow = 'details-dropdown--show';
		const dropdown = target.nextElementSibling;

		if (dropdown.classList.contains(classShow)) {
			target.querySelector('span').innerText = textMore;
		} else {
			target.querySelector('span').innerText = textHide;
		}
		target.querySelector('.fas').classList.toggle('fa-angle-down');
		target.querySelector('.fas').classList.toggle('fa-angle-up');

		dropdown.classList.toggle(classShow);

		return false;
	}

	const clickedSubmitButton = target.matches('.expedition-button');

	if (clickedSubmitButton || target.closest('.expedition-button')) {
		if (!clickedSubmitButton) {
			target = target.closest('.expedition-button');
		}

		let form = target.closest('form');
		if (window.Nette.validateForm(form)) {
			global.naja.makeRequest('post', form.action, new FormData(form), {
				history: false,
			});
		}
		return false;
	}
});
