<?php declare(strict_types=1);

namespace EshopOrders\AdminModule\Components\Invoice;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use EshopOrders\Model\Entities\Invoice;
use EshopOrders\Model\Invoices;
use Nette\Utils\ArrayHash;
use Tracy\Debugger;

class InvoiceEditForm extends BaseControl
{
	protected Invoices $invoices;
	protected Invoice $invoice;

	public function __construct(Invoice $invoice, Invoices $invoices)
	{
		$this->invoice = $invoice;
		$this->invoices = $invoices;
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	/*******************************************************************************************************************
	 * ======================== Components
	 */

	protected function createComponentForm(): BaseForm
	{
		$form = $this->createForm();
		$form->setShowLangSwitcher(false)
			 ->setAjax();

		$form->addTextArea('note', 'eshopOrders.editInvoiceForm.note')
			 ->setNullable()
			 ->setDefaultValue($this->invoice->note)
			 ->setHtmlAttribute('rows', 10);

		$form->addSaveCancelControl()
			 ->closeModalOnCancel();

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
		try {
			$invoice = $this->invoice;
			$invoice->note = $values->note;
			$this->em->persist($invoice)
					 ->flush($invoice);
		} catch (\Exception $exception) {
			Debugger::log($exception);
		}
	}

}