<?php declare(strict_types = 1);

namespace EshopOrders\ApiModule\Api\V1\Model\Dao;

class Spedition
{
	public int     $id;
	public string  $name;
	public string  $ident;
	public float   $price;
	public ?string $code1          = null;
	public ?string $code2          = null;
	public int     $isPickup       = 0;
	public int     $allowOversized = 0;
	public ?string $text           = null;
	public int     $isPublished    = 0;
	public int     $position       = 0;
	public ?int    $freeFrom       = null;
	public ?int    $availableFrom  = null;
	public ?int    $availableTo    = null;
	public ?float  $maxWeight      = null;
	public ?string $image          = null;
	public ?string $zboziId        = null;
	public ?string $heurekaId      = null;
	public ?string $googleId       = null;

	/** @var SpeditionWeight[] */
	public array $weights = [];

	public function __construct(
		int    $id,
		string $name,
		string $ident,
		float  $price
	)
	{
		$this->id    = $id;
		$this->name  = $name;
		$this->ident = $ident;
		$this->price = $price;
	}
}
