<?php declare(strict_types=1);

namespace EshopOrders\ApiModule\Api\V1\Model\Helpers;

use EshopOrders\ApiModule\Api\V1\Model\Dao\Address;
use EshopOrders\Model\Entities\OrderAddress;

class CustomerHelper
{
	public function fillAddressByOrderAddress(OrderAddress $orderAddress, Address $address): Address
	{
		$address->id          = $orderAddress->getId();
		$address->firstName   = $orderAddress->getFirstName();
		$address->lastName    = $orderAddress->getLastName();
		$address->email       = $orderAddress->getEmail();
		$address->phone       = $orderAddress->getPhone();
		$address->company     = $orderAddress->getCompany();
		$address->street      = $orderAddress->getStreet();
		$address->city        = $orderAddress->getCity();
		$address->postal      = $orderAddress->getPostal();
		$address->countryCode = $orderAddress->getCountry() ? $orderAddress->getCountry()->getId() : null;
		$address->idNumber    = $orderAddress->getIdNumber();
		$address->vatNumber   = $orderAddress->getVatNumber();

		return $address;
	}

}
